import {
  doAuthorizeGet as doGet,
  doPut,
  doPost,
  doDelete,
  poller,
} from 'wechat_common/utils/request'
import { ADMINTOOL_API_URL } from 'root/constants/admintool/urlConstants'

const customHeader = {
  headerName: 'Authorization',
}

function getVerifyCode(phone) {
  return doPost({
    url: ADMINTOOL_API_URL.GET_VERIFY_CODE(),
    data: {
      phone,
    },
  })
}

function authorize(phone, verifyCode) {
  return doPost({
    url: ADMINTOOL_API_URL.LOGIN(),
    data: {
      phone,
      verify_code: verifyCode,
    },
  })
}

function fetchWmpList() {
  return doGet({
    url: ADMINTOOL_API_URL.WMPLIST(),
    customHeader,
  })
}

function fetchUnreadCount() {
  return doGet({
    url: ADMINTOOL_API_URL.GET_UNREAD_COUNT(),
    customHeader,
  })
}

function fetchSummaryInfo(appId, storefrontId) {
  return doGet({
    url: ADMINTOOL_API_URL.SUMMARY_INFO(appId, storefrontId),
    customHeader,
  })
}

function fetchAnalytics(options) {
  return doGet({
    url: options,
    customHeader,
  })
}
function fetchMemberList(appId, orderBy, page) {
  return doGet({
    url: ADMINTOOL_API_URL.MEMBERLIST(appId, { order_by: orderBy, page }),
    customHeader,
  })
}

function fetchMemberDetail(appId, memberId) {
  return doGet({
    url: ADMINTOOL_API_URL.MEMBERLIST(appId, memberId),
    customHeader,
  })
}

function fetchMiniprogramPaymentOrders(options) {
  return doGet({
    url: options,
    customHeader,
  })
}

function fetchOrderDetail(appType, appId, orderNum, orderType) {
  const url = ADMINTOOL_API_URL.ORDERDETAIL(appType, appId, orderType, orderNum)
  return doGet({
    url,
    customHeader,
  })
}

function updateOrderDetail(appType, appId, orderNum, orderType, remark, status) {
  return doPut({
    url: ADMINTOOL_API_URL.ORDERDETAIL(appType, appId, orderType, orderNum),
    data: {
      remark,
      status,
    },
    customHeader,
  })
}

function setOrderStatus(appId, orderNum, status, shipping_notes) {
  if(status === 'shipped'){
    return doPost({
      url: ADMINTOOL_API_URL.ORDERDSTATUS(appId, orderNum, status),
      data: {
        status,
        deliveryMemberPhone: shipping_notes,
      },
      customHeader,
    })
  }else{
    return doPut({
      url: ADMINTOOL_API_URL.ORDERDSTATUS(appId, orderNum, status),
      data: {status},
      customHeader,
    })
  }
}

function fetchVisitorData(options) {
  return new Promise((resolve, reject) => {
    poller(options, resolve, reject, customHeader)
  })
}
function fetchComments(appId, status, page, storefrontId) {
  let options = {}
  if (storefrontId) {
    options = {
      page,
      storefrontId,
    }
  } else {
    options = {
      page,
    }
  }

  return doGet({
    url: ADMINTOOL_API_URL.COMMENTLIST(appId, status, options),
    customHeader,
  })
}

function approveComment(appId, commentId) {
  return doPut({
    url: ADMINTOOL_API_URL.APPROVECOMMENT(appId, commentId),
    data: {
      id: commentId,
    },
    customHeader,
  })
}

function deleteComment(appId, commentId) {
  return doDelete({
    url: ADMINTOOL_API_URL.DELETECOMMENT(appId, commentId),
    data: {
      id: commentId,
    },
    customHeader,
  })
}

function replyComment(appId, commentId, content, replyStatus) {
  return doPost({
    url: ADMINTOOL_API_URL.REPLYCOMMENT(appId),
    data: {
      id: commentId,
      content,
      status: replyStatus ? 4 : 3,
    },
    customHeader,
  })
}

function approveAllComments(appId, storefrontId) {
  return doPost({
    url: ADMINTOOL_API_URL.APPROVEALL(appId, storefrontId),
    data: storefrontId
      ? {
          storefrontId,
        }
      : null,
    customHeader,
  })
}

function markMemberAsRead(appId, memberId) {
  return doPost({
    url: ADMINTOOL_API_URL.MARK_MEMBER_AS_READ(appId, memberId),
    data: {
      id: memberId,
    },
    customHeader,
  })
}

function markOrderAsRead(appId, orderNumber) {
  return doPost({
    url: ADMINTOOL_API_URL.MARK_ORDER_AS_READ(appId, orderNumber),
    data: {
      orderNumber,
    },
    customHeader,
  })
}

function markCommentAsRead(appId, commentId) {
  return doPost({
    url: ADMINTOOL_API_URL.MARK_COMMENT_AS_READ(appId, commentId),
    data: {
      id: commentId,
    },
    customHeader,
  })
}

function createTicket(appId, content, attachments) {
  return doPost({
    url: ADMINTOOL_API_URL.CREATE_TICKET(appId),
    data: {
      id: appId,
      content,
      attachments,
    },
    customHeader,
  })
}

function upload(options) {
  wx.uploadFile({
    url: options.url,
    filePath: options.filePath,
    name: 'file',
    formData: {
      token: options.token,
    },
    success: res => {
      if (options.success) {
        options.success(res)
      }
    },
  })
}

function getUploadInfo(appId) {
  return doPost({
    url: ADMINTOOL_API_URL.GET_UPLOAD_INFO(appId),
  })
}

function fetchOrders({appType, appId, orderType, storefrontId, nextPage, status}) {
  let options = { page: nextPage }
  if (storefrontId) options.storefrontId = storefrontId
  if (status) options.status = status
  if (appType === 'restaurant'){
    options.type = orderType === 'dinein' ? 'dine_in' : orderType
  }
  //options.per = 8
  return doGet({
    url: ADMINTOOL_API_URL.ORDERLIST(appType, appId, orderType, options),
    customHeader,
  }).then(
    res => {
      switch(appType) {
        case 'restaurant':
          res.data.total = res.data.paginationMeta.totalCount || 0
          res.data.unread = res.data.unreadCount || 0
          break;
        case 'showcase':
          switch (orderType) {
            case 'sales':
              res.data.orders = res.data.sales
              res.data.total = res.data.totalSalesOrders || 0
              res.data.unread = res.data.salesOrdersUnread || 0
              break;
            case 'recharge':
              res.data.orders = res.data.recharges
              res.data.total = res.data.totalRechargeOrders || 0
              res.data.unread = res.data.rechargeOrdersUnread || 0
              break;
            case 'groupon':
              res.data.orders = res.data.grouponOrders
              res.data.total = res.data.paginationMeta.totalCount || 0
              res.data.unread = res.data.grouponOrdersUnread || 0
              break;
            default:
              break;
          }
          break;
        default:
          break;
      }
      return res
    }
  )
}

function fetchDocuments() {
  return doGet({
    url: ADMINTOOL_API_URL.DOCUMENTLIST(),
    customHeader,
  })
}

function fetchDocumentUnreadCount() {
  return doGet({
    url: ADMINTOOL_API_URL.DOCUMENT_UNREAD_COUNT(),
    customHeader,
  })
}

function fetchDocumentContent(id) {
  return doGet({
    url: ADMINTOOL_API_URL.DOCUMENT_CONTENT(id),
    customHeader,
  })
}

const admintoolApi = {
  fetchWmpList,
  fetchSummaryInfo,
  getVerifyCode,
  authorize,
  fetchComments,
  approveComment,
  fetchUnreadCount,
  fetchAnalytics,
  fetchMiniprogramPaymentOrders,
  fetchVisitorData,
  fetchMemberList,
  fetchMemberDetail,
  fetchOrderDetail,
  deleteComment,
  approveAllComments,
  replyComment,
  markMemberAsRead,
  markOrderAsRead,
  markCommentAsRead,
  createTicket,
  upload,
  getUploadInfo,
  fetchOrders,
  updateOrderDetail,
  fetchDocuments,
  fetchDocumentUnreadCount,
  fetchDocumentContent,
  setOrderStatus,
}
export default admintoolApi
