import {formatProtocol as _formatProtocol} from './tools'

export function formatProtocol(url) {
  if (!url) {
    return ''
  }
  return _formatProtocol(url)
}


export function convertPostLikes(post, nickname){
  const { isLiked, likes = [] } = post
  if(isLiked){
    let likedIndex = -1
    let isFirst = true
    for(let i = 0; i < likes.length; i++){
      if(isFirst && likes[i] === nickname){
        likedIndex = i
        isFirst = false
      }
    }
    post.likes = likes.filter((item, index) => index !== likedIndex)
  } else {
    (post.likes || []).push(nickname)
  }
  post.isLiked = !post.isLiked
  return post
}