import { doGet, doPost, doPut, poller } from 'wechat_common/utils/request'
import URLS from 'root/constants/giftcard/urls'

export function getProducts(url) {
  return doGet({ url })
}

export function getProduct(url) {
  return doGet({ url })
}

export function getCards(url) {
  return doGet({ url })
}

export function createOrder(options) {
  return new Promise((resolve, reject) => {
    doPost({
      url: options.url,
      data: options.data,
      success(res) {
        if (res.status === 200) {
          const { type, id } = res.data
          const pollUrl = URLS.POLL_ORDER(type, id)

          poller(pollUrl, resolve, reject)
        } else {
          resolve(res)
        }
      },
      fail() {
        reject()
      },
    })
  })
}

export function getPackets(url) {
  return doGet({ url })
}

export function getPacket(url) {
  return doGet({ url })
}

export function updatePacket(options) {
  return doPut(options)
}

export function getSettings(url) {
  return doGet({ url })
}
