export function debounce(fn, time = 100) {
  let handle
  handle = 0
  return function () {
    let args, context
    context = this
    args = arguments
    clearTimeout(handle)
    return (handle = setTimeout(() => fn.apply(context, args), time))
  }
}

export function formatProtocol(url) {
  if (!url) {
    return 'https://assets.sxlcdn.com/images/ecommerce/ecommerce-default-image.png'
  }
  const _url = url.replace('http:', '').replace('https:', '')
  return `https:${_url}`
}

export function formatAmount(amount) {
  // e.g. turn 1234 into 1.2k
  const result = amount / 1000
  if (result > 1) {
    return `${Math.round(result * 10) / 10}k`
  } else {
    return amount
  }
}

export function customNavigateTo(data) {
  setTimeout(() => {
    wx.navigateTo(data)
  }, 50)
}
