export function getQnUrl(image) {
  function isUnsplash(url) {
    return url.indexOf('unsplash') !== -1
  }

  if (!image.storageKey) {
    return ''
  }

  if (isUnsplash(image.storageKey)) {
    return `${image.storageKey}?h=1500&w=2000&q=40&fit=clip&fm=jpg`
  }

  return `https://user-assets.sxlcdn.com/${
    image.storageKey
    }?imageMogr2/strip/thumbnail/1200x9000>/format/${image.format}`
}
