import urls from '/constants/blog/urls'
import Fly from '/lib/flyio/index'
const fly = new Fly()

const { REQUESTS } = urls

export const getPostDetail = postId => fly.get(REQUESTS.GET_POST(postId))

export const getPosts = (siteId, category, pageNum) =>
  fly.get(REQUESTS.GET_POSTS(siteId, category, pageNum))

export const likePost = (status, postId, nickName, avatarUrl) =>
  status ? REQUESTS.SET_LIKE_POST(postId) : REQUESTS.DELETE_LIKE_POST(postId)

export const getCategories = siteId => fly.get(REQUESTS.GET_CATEGORIES(siteId))

export const getComments = (postId, pageNum) => fly.get(REQUESTS.GET_COMMENTS(postId, pageNum))

export const setComments = (postId, comment) => fly.post(REQUESTS.SET_COMMENTS(postId), comment)