# moreartyjs

管理（state：结合 immutable ）层


1. 向子组件传递：

```
// pass to sub components
var binding = this.getDefaultBinding();

<Header binding={ binding } />
```

2. retrieved: `getDefaultBinding` method 

```

this.getDefaultBinding().update('items', function (todos) {
	// do sth update here
})
```

3. dom 与 callback

```
<Morearty.DOM.input id='new-todo' // // requestAnimationFrame-friendly wrapper around input
    ref='newTodo'
    placeholder='What needs to be done?'
    onKeyDown={ Morearty.Callback.onEnter(this.onAddTodo) } />
```


# immutable

包括 List, Stack, Map, OrderedMap, Set, OrderedSet 和 Record 以及一系列方法。

常用的有 List、Map 和 Set

```
const map = Immutable.map({
	a: 1,
	b: 2,
	c: 3
});

const mapNew = map.set('b', 50);	// note: return totally new object
```

```
const list = Immutable.list([1,2]);
const listNew = list.push(3);
```
等等

1. Map 类似 key/value object

```
const map = Immutable.Map({ a: 1 });
```


2. List 类似一般的 Array

```
const arr = Immutable.List([1, 2, 3]);
```

3. Set 没有顺序但不能重复的 Array

```
const set = Immutable.Set([1, 2, 3]);
```
4. tip:  Structural Sharing， 树中一个节点变化，不会影响其他节点

```
const obj = {
 count: 1,
 list: [1, 2, 3, 4, 5]
}
var map1 = Immutable.fromJS(obj);
var map2 = map1.set('count', 4);

console.log(map1.list === map2.list); // true

```


5. 常用 API

```
fromJS(); // js 2 immutable
toJS(); 	// immutable 2 js
is(); // 比较的是 两个对象的 hashcode 和 valueOf
has() hasIn;  // if key in, 加 In：深层
includes();		// if value in
```





