import React, { useState, useEffect } from 'react';
import Button from 'react-bootstrap/Button';
import Form from 'react-bootstrap/Form';
import Modal from 'react-bootstrap/Modal';
import Col from 'react-bootstrap/Col';
import Row from 'react-bootstrap/Row';
import Toast from 'react-bootstrap/Toast';

export function EmailPopup() {
    const [show, setShow] = useState(false);
    const storedEmail = localStorage.getItem('email')

    useEffect(() => {
    if (storedEmail === null) {
      setShow(true);
    }
  }, [storedEmail]);



    const [email, setEmail] = useState(storedEmail);
    const [validEmail, setValidEmail] = useState(false);

    // const handleClose = () => setShow(false);
    const handleShow = () => setShow(true);

    const handleEmailChange = (e) => {
        const email = e.target.value;
        setValidEmail(/^[\w-.]+@([\w-]+\.)+[\w-]{2,4}$/.test(email));
        setEmail(email);
    };


    const handleSubmit = (e) => {
        e.preventDefault();
        const storedEmail = localStorage.getItem('email')
        if (validEmail) { 
            localStorage.setItem('email', email);
            console.log(storedEmail)
            setShow(false);
        }
    };


    return (
        <>
        <Button variant="dark" onClick={handleShow}>
            {email}
        </Button>

        {/* <Modal show={show} onHide={handleClose}> */}
        {/* No onHide so that the user cannot close the popup without submitting an email */}
        <Modal show={show}>  
            <Modal.Header>
            <Modal.Title>Please Enter Email</Modal.Title>
            </Modal.Header>
            <Modal.Body>
            <Form>
                <Form.Group className="mb-3" controlId="emailAddress">
                <Form.Label>Email address</Form.Label>
                <Form.Control
                    type="email"
                    placeholder="name@example.com"
                    onChange={handleEmailChange}
                    autoFocus
                />
                </Form.Group>
            </Form>
            </Modal.Body>
            <Modal.Footer>
            <Button variant="primary" onClick={handleSubmit}>
                Submit
            </Button>
            </Modal.Footer>
        </Modal>
        </>
    );
    }



export function FeedbackModal({showFeedbackModal, onClose}) {
    const [show, setShow] = useState(showFeedbackModal);
    const [feedback, setFeedback] = useState('');
    const [submitToast, setSubmitToast] = useState(false);


    const handleClose = () => {
        setShow(false);
        onClose();
    };

    const handleClear = () => setFeedback('')

    const handleFeedbackChange = (event) => {
        setFeedback(event.target.value);
    }

    const handleSubmit = () => {
        // do something with the feedback
        if (feedback === '') {
            setFeedback("Please do not send empty feedback. Please click 'Clear' and write you feedback");
            return
        }
        const storedEmail = localStorage.getItem('email')
        const timestamp = new Date();
        const options = { timeZone: 'Asia/Shanghai'  };
        const date = timestamp.toLocaleDateString('en-US', options);  // Get date in format mm/dd/yy
        const time = timestamp.toLocaleTimeString('en-US', options);  // Get time in format hh:mm:ss
        const dateTime = `${date} ${time} UTC+8`;  // Combine date and time into one string
        const feedbackData = {
            email: storedEmail,
            time: dateTime,
            feedback:feedback,
            range: "Feedback"
        };

        console.log(feedbackData)
        fetch("https://strk-ai-support.ngrok.app/v1/ai-support/feedbacks", {
        // fetch("https://13313306f1aa.ngrok.app/v1/ai-support/feedbacks", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify(feedbackData)
        })
        .then((response) => {
            if (response.ok) {
                return response.json();
            } else {
                throw "some error text";
            }
        })
        .then((data) => {
            console.log(data)
            setSubmitToast(true)
        })
        .catch((error) => {
            setFeedback("Error. Try again later. If the error persists, please contact the developer.");
            console.error("Request failed:", error);
        })

        // handleClose();
    }

    function AutohideSubmitToast() {
        return (
          <Row>
            <Col xs={12} className="mb-2">
                <Button variant="secondary" onClick={handleClear} className="mr-2">
                    Clear
                </Button>
                <Button variant="primary" onClick={handleSubmit} className="ms-2">
                    Submit
                </Button>
            </Col>
            <Col xs={12}>
                <Toast onClose={() => setSubmitToast(false)} show={submitToast} delay={1500} autohide>
                    <Toast.Body>Feedback sent successfully</Toast.Body>
                </Toast>
            </Col>
          </Row>
        );
    }



    return (
        <>
        <Modal show={show} onHide={handleClose}>
            <Modal.Header closeButton>
            <Modal.Title>Feedback</Modal.Title>
            </Modal.Header>
            <Modal.Body>
            <Form>
                <Form.Group
                className="mb-3"
                controlId="exampleForm.ControlTextarea1"
                >
                <Form.Label>Note: The feedback will be sent directly to Kodi devs.</Form.Label>
                <Form.Control as="textarea" rows={8} value={feedback} onChange={handleFeedbackChange}/>
                </Form.Group>
            </Form>
            </Modal.Body>
            <Modal.Footer  className="d-flex justify-content-start align-items-end">
                <AutohideSubmitToast/>
            </Modal.Footer>
        </Modal>
        </>
    );
}


