import { useState } from "react";
import {
  Button,
  Col,
  Container,
  Form,
  FormLabel,
  Navbar,
  Row,
} from "react-bootstrap";
import io from "socket.io-client";
import "../App.css";
// import Chatbox from "./Chatbox";
let messageBox = document.querySelector("#message-box");

// const url = 'https://8788-103-84-218-44.ngrok-free.app'
const url = 'https://staging.strk-ai-support.ngrok.app/'
// const url = 'http://localhost:8000'

const socket = io(url, {
  extraHeaders: {
    "ngrok-skip-browser-warning": "123",
  },
});

// socket.emit("join", {
//   username: "test",
//   room: "default",
// });
socket.on("connect", (data) => {
  console.log(data);
});

socket.on("send msg", function (data) {
  console.log(data);
  console.log(socket.id);
  let msg = null;
  let msgbox = document.createElement("div");
  msgbox.className = "row";

  msg = `
            <div class="col">
              <div class="tag z-depth-3">
                <span class="teal-text"><b>${data.user}</b>:  ${data.message}
                </span>
              </div>
            </div>`;

  msgbox.innerHTML = msg;
  messageBox.appendChild(msgbox);
  messageBox.scrollTop = messageBox.scrollHeight;
});

function Chat() {
  const [languageSupport, setLanguageSupport] = useState("English");
  const [languageUser, setLanguageUser] = useState("Simple Chinese");
  const [userMessage, setUserMessage] = useState("");
  const [supportMessage, setSupportMessage] = useState("");
  const [supportName, setSupportName] = useState("");
  const [userName, setUserName] = useState("");

  const sendUserMessage = (event, user) => {
    if (!supportName || !userName) {
      alert("Please enter user name and support name");
      return;
    }
    if (userMessage) {
      socket.emit("send msg", {
        user: "user",
        message: userMessage,
        languageSupport: languageSupport,
        languageUser: languageUser,
      });
      setUserMessage("");
    } else {
      alert("Message cannot be empty");
    }
  };

  const sendSupportMessage = (event, user) => {

    if (!supportName || !userName) {
      alert("Please enter user name and support name");
      return;
    }
    if (supportMessage) {
      socket.emit("send msg", {
        user: "support",
        message: supportMessage,
        languageSupport: languageSupport,
        languageUser: languageUser,
      });
      setSupportMessage("");
    } else {
      alert("Message cannot be empty");
    }
  };

  const setName = () => {
    console.log(supportName);
    console.log(userName);
    if (supportName && userName) {
      socket.emit("set room", {
        support_name: supportName,
        user_name: userName,
      });

      socket.emit("join", {
        username: supportName,
        room: supportName + '-' + userName,
      });
    }
  }

  return (
    <Container>
      <Navbar bg="dark" variant="dark">
        <Navbar.Brand href="#home">Chat Room</Navbar.Brand>
        <Navbar.Collapse className="justify-content-end"></Navbar.Collapse>
      </Navbar>
      <Row>
        <Col>
          <FormLabel>user name</FormLabel>
          <Form.Control
            type="text"
            value={userName}
            onChange={(e) => setUserName(e.target.value)}
            placeholder="Enter user name"
          />
        </Col>
        <Col>
          <FormLabel>support name</FormLabel>
          <Form.Control
            type="text"
            value={supportName}
            onChange={(e) => setSupportName(e.target.value)}
            placeholder="Enter support name"
          />
        </Col>
        <Button onClick={(e) => setName()}>Submit(You should set user name and support name first!)</Button>
      </Row>
      <Row>
        <Col>
          <FormLabel>user</FormLabel>
          <Form.Control
            as="select"
            onChange={(e) => setLanguageUser(e.target.value)}
          >
            <option value="Simplified Chinese">Simplified Chinese</option>
            <option value="Traditional Chinese">Traditional Chinese</option>
            <option value="Italiano">Italiano</option>
            <option value="German">German</option>
            <option value="Japanese">Japanese</option>
            <option value="French">French</option>
            <option value="Arabic">Arabic</option>
            <option value="Spanish">Spanish</option>
            <option value="Dutch">Dutch</option>
            <option value="Portuguese">Portuguese</option>
            <option value="Finnish">Finnish</option>
            <option value="Norwegian">Norwegian</option>
            <option value="Swedish">Swedish</option>
            <option value="Czech">Czech</option>
            <option value="Romanian">Romanian</option>
            <option value="Indonesian">Indonesian</option>
            <option value="Polish">Polish</option>
            <option value="Vietnamese">Vietnamese</option>
            <option value="Korean">Korean</option>
          </Form.Control>
          <Form.Control
            type="text"
            value={userMessage}
            onChange={(e) => setUserMessage(e.target.value)}
            placeholder="Enter message"
          />
          <Button onClick={(e) => sendUserMessage(e, "user")}>Send</Button>
        </Col>
        <Col>
          <FormLabel>support</FormLabel>
          <Form.Control
            as="select"
            onChange={(e) => setLanguageSupport(e.target.value)}
          >
            <option value="English">English</option>
            <option value="Simplified Chinese">Simplified Chinese</option>
            {/* add other languages here */}
          </Form.Control>
          <Form.Control
            type="text"
            value={supportMessage}
            onChange={(e) => setSupportMessage(e.target.value)}
            placeholder="Enter message"
          />
          <Button onClick={(e) => sendSupportMessage(e, "support")}>
            Send
          </Button>
          
        </Col>
      </Row>
    </Container>
  );
}

export default Chat;
