<a name="readme-top"></a>


<br />
<div align="center">

<h3 align="center">Kodi front-end website</h3>

  <p align="center">
    Front-end Web for Kodi
    <br />
    <a href="https://cd.i.strikingly.com/ai-support/web"><strong>Explore the docs »</strong></a>
    <br />
    <br />
    <a href="http://ai-support.pages.i.strikingly.com/web/">View Demo</a>
  </p>
</div>



<!-- TABLE OF CONTENTS -->
<details>
  <summary>Table of Contents</summary>
  <ol>
    <li>
      <a href="#about-the-project">About The Project</a>
      <ul>
        <li><a href="#built-with">Built With</a></li>
      </ul>
    </li>
    <li>
      <a href="#getting-started">Getting Started</a>
      <ul>
        <li><a href="#prerequisites">Prerequisites</a></li>
        <li><a href="#installation">Installation</a></li>
      </ul>
    </li>
    <li><a href="#usage">Usage</a></li>
    <li><a href="#contact">Contact</a></li>
    <li><a href="#acknowledgments">Acknowledgments</a></li>
  </ol>
</details>



<!-- ABOUT THE PROJECT -->
## About The Project

This project is the front-end website of Kodi server. It's a website built with React. On the website, the users are able to enter question, and then click Kodi-Template or Kodi-Support to get corresponding answers. Every generated answer will be sent to our google sheet. After that, they can click "Copy Good Answer" is the answer is great, or click "Thumb down" or "Regenerate" is the answer is not good.

<p align="right">(<a href="#readme-top">back to top</a>)</p>



### Built With

* [![React][React.js]][React-url]
* [![Bootstrap][Bootstrap.com]][Bootstrap-url]

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- GETTING STARTED -->
## Getting Started

This is an example of how you may give instructions on setting up your project locally.
To get a local copy up and running follow these simple example steps.

### Prerequisites

This is an example of how to list things you need to use the software and how to install them.
* npm
  ```sh
  npm install npm@latest -g
  ```

### Installation

1. Clone the repo
   ```sh
   git clone git@cd.i.strikingly.com:ai-support/web.git
   ```
2. Install NPM packages
   ```sh
   npm install
   ```
3. Runs the app in the development mode. Open http://localhost:3000 to view it in your browser.
   ```sh
   npm start
   ```

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- USAGE EXAMPLES -->
## Usage

### Explaination of core files
* App.js: The main file of the website. It defines all the main functionalities of this web, including entering the question, sending the question to the server by fetch, getting streaming response from the server, and send feedback of the response.

* modal.js: Include 2 modal objects. The first one EmailModal is the Modal Popup that will show when the user first opens the website. An email is needed to be submitted to use the web. The second one is the FeedbackModal. When the user click the button "Feedback", the FeedbackModal will occur where user can write their feedback and send to the target google sheet.

* .gitlab-ci.yml: The .gitlab-ci.yml file is a configuration file used by GitLab CI/CD to define the pipeline stages and jobs for building and deploying this project. It's required for this project to be deployed on GitLab pages.



<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- CONTACT -->
## Contact

Project Link: [https://cd.i.strikingly.com/ai-support/web](https://cd.i.strikingly.com/ai-support/web)

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- ACKNOWLEDGMENTS -->
## Acknowledgments

* [React Bootstrap](https://react-bootstrap.github.io/)
* [React](https://react.dev/)
* [Javascript](https://www.javascript.com/)

<p align="right">(<a href="#readme-top">back to top</a>)</p>



<!-- MARKDOWN LINKS & IMAGES -->
<!-- https://www.markdownguide.org/basic-syntax/#reference-style-links -->
[React.js]: https://img.shields.io/badge/React-20232A?style=for-the-badge&logo=react&logoColor=61DAFB
[React-url]: https://reactjs.org/
[Bootstrap.com]: https://img.shields.io/badge/Bootstrap-563D7C?style=for-the-badge&logo=bootstrap&logoColor=white
[Bootstrap-url]: https://getbootstrap.com

