import React, { useEffect } from 'react';

function Test() {
  useEffect(() => {
    // 检查URL是否已经有token
    const currentUrl = new URL(window.location.href);
    if (!currentUrl.searchParams.get('token')) {
      // 生成新的token
      const token = generateToken();
      
      // 更新URL
      currentUrl.searchParams.set('token', token);
      window.history.replaceState({}, '', currentUrl.toString());

      // 保存token到sessionStorage
      sessionStorage.setItem('sessionToken', token);
    }
  }, []);

  // 这只是一个简单的token生成函数，真正的应用中，您可能需要更加复杂和安全的生成机制
  const generateToken = () => {
    return Math.random().toString(36).substr(2, 9);
  };

  return (
    <div className="App">
      <h1>Welcome to my React App</h1>
    </div>
  );
}

export default Test;
