import React, { useEffect, useState } from "react";
import {
  Col,
  Container,
  Form,
  FormLabel,
  ListGroup,
  Row
} from "react-bootstrap";
import io from "socket.io-client";
import "../App.css";

const url = 'https://staging.strk-ai-support.ngrok.app/'
// const url = "http://localhost:8000";

const socket = io(url, {
  extraHeaders: {
    "ngrok-skip-browser-warning": " ",
  },
});

function ChatTrans() {
  const [languageSupport, setLanguageSupport] = useState("English");
  const [languageUser, setLanguageUser] = useState("Simplified Chinese");
  const [userMessage, setUserMessage] = useState("");
  const [supportMessage, setSupportMessage] = useState("");
  const [supportName, setSupportName] = useState("");
  const [userName, setUserName] = useState("");

  const [userMessages, setUserMessages] = useState([]);
  const [supportMessages, setSupportMessages] = useState([]);
  const [room, setRoom] = useState("");

  const [loading, setLoading] = useState(true);

  const generateToken = () => {
    return Math.random().toString(36).substr(2, 9);
  };

  useEffect(() => {
    // 检查URL是否已经有token
    const currentUrl = new URL(window.location.href);

    if (!currentUrl.searchParams.get("token")) {
      // 生成新的token
      const token = generateToken();

      // 更新URL
      currentUrl.searchParams.set("token", token);
      window.history.replaceState({}, "", currentUrl.toString());

      // 保存token到sessionStorage
      sessionStorage.setItem("sessionToken", token);
    }
    console.log(currentUrl.searchParams.get("token"));

    setRoom(currentUrl.searchParams.get("token"));

    socket.emit("join", {
      room: currentUrl.searchParams.get("token"),
    });

    if (userMessages.length === 0 && supportMessages.length === 0) {
      socket.emit("history", {
        room: currentUrl.searchParams.get("token"),
      });
    }

  }, []);

  socket.on("send msg", function (data) {
    let messge = data.user + ": " + data.message;
    if (data.user === "user") {
      setSupportMessages([...supportMessages, messge]);
    } else {
      setUserMessages([...userMessages, messge]);
    }
  });

  socket.on("history", function (data) {
    let user = data.user;
    let messages = data.messages;

    if (user === "user") {
      setUserMessages(messages);
    } else {
      setSupportMessages(messages);
      setLoading(false);
    }
    
  });

  const sendMessage = (
    event,
    user,
    message,
    messages,
    setMessage,
    setMessages
  ) => {
    if (message) {
      socket.emit("send msg", {
        user: user,
        message: message,
        languageSupport: languageSupport,
        languageUser: languageUser,
        room: room,
      });
      setMessage("");
      setMessages([...messages, user + ": " + message]);
    }
  };

  const onKeyDown = function (e, user) {
    if (e.keyCode === 13) {
      if (user === "user") {
        sendMessage(
          e,
          "user",
          userMessage,
          userMessages,
          setUserMessage,
          setUserMessages
        );
      } else {
        sendMessage(
          e,
          "support",
          supportMessage,
          supportMessages,
          setSupportMessage,
          setSupportMessages
        );
      }
    }
  };

  const newPage = () => {
    window.open("/chat");
  }
  return (
    <Container>
      <Row>
      <button
            id="ChatButton"
            className="btn btn-success"
            onClick={newPage}
            // disabled={buttonStatus === "generating"}
          >
            New Chat
          </button>      </Row>
      <Row>
        <Col>
          <FormLabel>user</FormLabel>
          <Form.Control
            as="select"
            onChange={(e) => setLanguageUser(e.target.value)}
          >
            <option value="Simplified Chinese">Simplified Chinese</option>
            <option value="Traditional Chinese">Traditional Chinese</option>
            <option value="Italian">Italian</option>
            <option value="German">German</option>
            <option value="Japanese">Japanese</option>
            <option value="French">French</option>
            <option value="Arabic">Arabic</option>
            <option value="Spanish">Spanish</option>
            <option value="Dutch">Dutch</option>
            <option value="Portuguese">Portuguese</option>
            <option value="Finnish">Finnish</option>
            <option value="Norwegian">Norwegian</option>
            <option value="Swedish">Swedish</option>
            <option value="Czech">Czech</option>
            <option value="Romanian">Romanian</option>
            <option value="Indonesian">Indonesian</option>
            <option value="Polish">Polish</option>
            <option value="Vietnamese">Vietnamese</option>
            <option value="Korean">Korean</option>
          </Form.Control>
          <Form.Control
            type="text"
            value={userMessage}
            onChange={(e) => setUserMessage(e.target.value)}
            placeholder="Enter message"
            onKeyDown={(e) => onKeyDown(e, "user")}
          />
        </Col>
        <Col>
          <FormLabel>support</FormLabel>
          <Form.Control
            as="select"
            onChange={(e) => setLanguageSupport(e.target.value)}
          >
            <option value="English">English</option>
            <option value="Simplified Chinese">Simplified Chinese</option>
          </Form.Control>
          <Form.Control
            type="text"
            value={supportMessage}
            onChange={(e) => setSupportMessage(e.target.value)}
            placeholder="Enter message"
            onKeyDown={(e) => onKeyDown(e, "support")}
          />
        </Col>

        <Row>
          <Col>
            {loading ? <FormLabel>Loading...</FormLabel> : null}
            <ListGroup variant="flush">
              {userMessages.map((message, index) => (
                <ListGroup.Item key={index}>{message}</ListGroup.Item>
              ))}
            </ListGroup>
          </Col>
          <Col>
            {loading ? <FormLabel>Loading...</FormLabel> : null}
            <ListGroup variant="flush">
              {supportMessages.map((message, index) => (
                <ListGroup.Item key={index}>{message}</ListGroup.Item>
              ))}
            </ListGroup>
          </Col>
        </Row>
      </Row>
    </Container>
  );
}

export default ChatTrans;
