// Learn cc.Class:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/class.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/class.html
// Learn Attribute:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/reference/attributes.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/reference/attributes.html
// Learn life-cycle callbacks:
//  - [Chinese] http://docs.cocos.com/creator/manual/zh/scripting/life-cycle-callbacks.html
//  - [English] http://www.cocos2d-x.org/docs/creator/en/scripting/life-cycle-callbacks.html

cc.Class({
    extends: cc.Component,

    properties: {
        slider1: {
            default: null,
            type: cc.Node,
        },
        slider2: {
            default: null,
            type: cc.Node,
        },
        slider3: {
            default: null,
            type: cc.Node,
        }
    },
    slider1Action: function() {
        return () => { 
            cc.sequence(
                cc.moveTo(2, cc.p(-343, 0)),
                cc.moveTo(2, cc.p(343, 0)),
                cc.delayTime(2),
            )
        }
    },
    slider2Action: function () {
        return cc.sequence(
            cc.moveTo(2, cc.p(0, 0)),
            cc.moveTo(2, cc.p(-343, 0)),
            cc.delayTime(4),
        )
    },
    slider3Action: function () {
        return cc.sequence(
            cc.delayTime(4),
            cc.moveTo(2, cc.p(0, 0)),
            cc.moveTo(2, cc.p(-343, 0)),
            cc.moveTo(2, cc.p(343, 0)),
        )
    },
    // LIFE-CYCLE CALLBACKS:

    onLoad () {
        // var self = this
        // var slider1 = cc.find('slider1', self.node)
        // var slider2 = cc.find('slider2', self.node)
        // var slider3 = cc.find('slider3', self.node)
        this.slider1.runAction(cc.repeatForever(cc.sequence(
            cc.delayTime(1),
            cc.moveTo(1, cc.p(-343, 0)),
            cc.hide(),
            cc.moveTo(3, cc.p(343, 0)),
            cc.show(),
            cc.moveTo(1, cc.p(0, 0))
        )))
        this.slider2.runAction(cc.repeatForever(cc.sequence(
            cc.delayTime(1),
            cc.moveTo(1, cc.p(0, 0)),
            cc.delayTime(1),
            cc.moveTo(1, cc.p(-343, 0)),
            cc.hide(),
            cc.moveTo(2, cc.p(343, 0)),
            cc.show(),
        )))
        // this.slider2.runAction(this.slider2Action)
        this.slider3.runAction(cc.repeatForever(cc.sequence(
            cc.hide(),
            cc.moveTo(3, cc.p(343, 0)),
            cc.show(),
            cc.moveTo(1, cc.p(0, 0)),
            cc.delayTime(1),
            cc.moveTo(1, cc.p(-343, 0)),
            
        )))
    },

    start () {

    },

    // update (dt) {},
});
