

cc.Class({
    extends: cc.Component,
    /** 游戏的全局变量 */

    properties: {
        /** 游戏节点的注册 */

        // logo节点
        logo: {
            default: null,
            type: cc.Node,
        },

        // btn_start节点
        start_btn: {
            default: null,
            type: cc.Node,
        },

        teacher: {
            default: null,
            type: cc.Node,
        },

        // classroom节点
        classroom: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // index节点
        index: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // hand节点
        hand: {
            default: null,
            type: cc.Node,
        },

        // store number节点
        score_number: {
            default: null,
            type: cc.Label,
        },

        // board节点
        board: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // level节点
        level: {
            default: null,
            type: cc.ProgressBar,
        },

        // failure节点
        failure: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // success节点
        success: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // success_result节点
        success_result: {
            default: null,
            type: cc.Label,
        },

        // 背景音乐节点
        bgMusic: {
            default: null,
            type: cc.AudioSource,
        },

        // 点击音乐节点
        clickMusic: {
            default: null,
            type: cc.AudioSource,
        },

        // 咆哮音乐
        roarMusic: {
            default: null,
            type: cc.AudioSource,
        },

        // 报警音乐
        policeMusic: {
            default: null,
            type: cc.AudioSource,
        },

        // 心跳音乐
        heartMusic: {
            default: null,
            type: cc.AudioSource,
        },

        // slider节点
        slider1: {
            default: null,
            type: cc.Node,
        },
        slider2: {
            default: null,
            type: cc.Node,
        },
        slider3: {
            default: null,
            type: cc.Node,
        },

        // 动态图片
        spriteFrame: {
            default: null,
            type: cc.SpriteFrame
        },

        // 排行榜节点
        rank: {
            default: null,
            type: cc.Node,
        },
    },

    initNode: function() {
        var self = this
        self.hand.active = true
        self.index.active = true
        self.success.active = false
    },


    initData: function() {
        // 初始化游戏数据
        this.score = 0; // 分数
        this.timer = 30; // 每一盘游戏的总时间
        this.leftLife = 3; // 剩余的命条数
        this.swivelAnimationTime = 0.5; //转头动画时间 （单向）
        this.flirtAnimationTime = 0.5; //摸的动画时间（单向）
        this.gameState = 'waiting'; // 游戏的状态 waiting(待开始)  action(游戏中)  stop(被抓)  over(分数总结)
    },

    onLoad: function () {
        this.initData()

        // 奖Game组件的实例传入开始按钮
        var startBtn = cc.find('index/start_btn', this.node);
        startBtn.getComponent('Start').game = this;

        // 将Game组件的实例传入teacher
        var teacher = cc.find('teacher', this.node);
        teacher.getComponent('Teacher').game = this;

        // 将Game组件的实例传入hand
        var hand = cc.find('hand', this.node)
        hand.getComponent('Hand').game = this

        // 将Game组件的实例传入成功的playAgain
        var successPlayAgain = cc.find('success/playAgain', this.node)
        successPlayAgain.getComponent('Restart').game = this
        
        // 将Game组件的实例传入失败的playAgain
        var failurePlayAgain = cc.find('failure/playAgain', this.node)
        failurePlayAgain.getComponent('Restart').game = this

        // 将Game组件的实例传入成功的Share
        var successShare = cc.find('success/share', this.node)
        successShare.getComponent('Share').game = this

        // 将Game组件的实例传入失败的Share
        var failureShare = cc.find('failure/share', this.node)
        failureShare.getComponent('Share').game = this

        // 将Game组件的实例传入成功的 Rank
        var successRank = cc.find('success/rank', this.node)
        successRank.getComponent('Rank').game = this

        // 将Game组件的实例传入失败的Rank
        var failureRank = cc.find('failure/rank', this.node)
        failureRank.getComponent('Rank').game = this

        // 将Game组件的实例传入排行榜Rank
        var RankTop = cc.find('rank/playAgain', this.node)
        RankTop.getComponent('Restart').game = this

        // 播放背景音乐
        this.playBackgroundMusic()

    },

    // 更改时间进度条
    updateLevelProgress: function() {
        var isYelling = this.teacher.getComponent('Teacher').isYelling
        if(this.level.progress > 0) {
            if (!isYelling) {
                this.level.progress -=  ((1 / this.timer) / 60)
            }
        } else {
            this.gameOver()
        }

        if(this.level.progress < 0.8 && this.level.progress > 0.2) {
            this.level.barSprite.node.color = {
                a: 1,
                b: 64,
                g: 178,
                r: 239
            }
        }  else if (this.level.progress <= 0.2) {
            this.level.barSprite.node.color = {
                a: 1,
                b: 75,
                g: 76,
                r: 232,
            }
        }
    },

    // 添加分数
    gainScore: function() {
        var isYelling = this.teacher.getComponent('Teacher').isYelling
        if (!isYelling) {
            this.score += 3;
            this.score_number.string = this.score.toString();
        }
    },
    
    // 被抓检测
    getCaught: function() {

        var isFlirting = this.hand.getComponent('Hand').isFlirting
        var isSwiveling = this.teacher.getComponent('Teacher').isSwiveling
        if (isFlirting) {
            this.heartMusic.play()
        } 
        return isSwiveling && isFlirting
    },

    // 播放背景音乐
    playBackgroundMusic: function() {
        this.bgMusic.play()
    },

    // 停止背景音乐
    stopBackgroundMusic: function() {
        this.bgMusic.pause()
    },

    // 添加点击音效
    clickSound: function () {
        this.clickMusic.play()
    },

    // 播发咆哮音效
    playRoarMusic: function() {
        this.roarMusic.play()
    },

    // 播放报警音乐
    playPoliceMusic: function() {
        this.policeMusic.play()
    },

    // 播放心跳音乐
    playHeartMusic: function() {
        this.heartMusic.play()
    },

    // 游戏帧循环
    update: function(dt) {
        if (this.gameState === 'action') {
            this.updateLevelProgress()
            if (this.getCaught()) {
                // this.gameFail()
                this.teacher.getComponent('Teacher').showFailImage()

            }
        } 
    },

    // 游戏开始
    startGame: function() {
         cc.director.loadScene('game')
    },

    // 游戏暂停
    gameFail: function() {
        this.success_result.string = this.score.toString()
        this.classroom.active = false
        this.failure.active = true
        this.hand.active = false
        this.board.active = false
        this.teacher.active = false
        this.gameState = 'stop'        
    },

    // 游戏结束
    gameOver: function() {
        var self = this
        this.success_result.string = this.score.toString()
        this.classroom.active = false
        this.success.active = true
        this.hand.active = false
        this.board.active = false
        this.teacher.active = false
        this.gameState = 'waiting'

        var remoteDomain = 'https://nzr2ybsda.qnssl.com/images/153823/'
        var pictures = [
            {
              "level": 1,
              "pictures": [
                "https://nzr2ybsda.qnssl.com/images/153823/Fo5on4A0pScy96ePN-2vtToLhHWN.jpg?imageMogr2/strip/thumbnail/260x260>/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/FlJQyhmeWyked6lekjh-Yln9nJUD.jpg?imageMogr2/strip/thumbnail/260x260>/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/Filk-VYB6CVCDEkHHgRPUc2c6k9T.jpg?imageMogr2/strip/thumbnail/130x130>/interlace/1/format/jpg"
              ]
            },
            {
              "level": 2,
              "pictures": [
                "https://nzr2ybsda.qnssl.com/images/153823/FukPQtvtJr-lKlYJPANNPdjjEiyt.jpeg?imageMogr2/strip/thumbnail/130x130>/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/Flhh6hGAhnSbuHajEEN-c2dCJfaK.jpg?imageMogr2/strip/thumbnail/130x130>/quality/90!/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/FjcKpOaAtIfz4L4Vvkif-EClqn64.jpg?imageMogr2/strip/thumbnail/260x260>/quality/90!/interlace/1/format/jpg"
              ]
            },
            {
              "level": 3,
              "pictures": [
                "https://nzr2ybsda.qnssl.com/images/153823/FpyOcbiPM8tDXogYzGDPDEFrO_T9.jpg?imageMogr2/strip/thumbnail/130x130>/quality/90!/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/Fn939nNNkFzW_htvSvBkvwvl6TMh.jpg?imageMogr2/strip/thumbnail/130x130>/quality/90!/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/Fo_IiyCr10dZIR6J7dJ9y7hs8nae.jpeg?imageMogr2/strip/thumbnail/260x260>/quality/90!/interlace/1/format/jpg"
              ]
            },
            {
              "level": 4,
              "pictures": [
                "https://nzr2ybsda.qnssl.com/images/153823/FhUfcO8E990i02gJ7hnpz7xCSc3o.jpg?imageMogr2/strip/thumbnail/130x130>/quality/90!/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/FvoIECoOwdGFgeFMuIOIWzAkg61Y.jpg?imageMogr2/strip/thumbnail/260x260>/quality/90!/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/FqxgwpiGV-U3KiwK4CHUm1B0zdSH.jpg?imageMogr2/strip/thumbnail/260x260>/interlace/1/format/jpg"
              ]
            },
            {
              "level": 5,
              "pictures": [
                "https://nzr2ybsda.qnssl.com/images/153823/Fk-9x5cihrhKFGMZHMglOqQEddkv.jpg?imageMogr2/strip/thumbnail/260x260>/quality/90!/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/FkdzV_YWdahiMGKB02Yp2CoTYgMS.jpg?imageMogr2/strip/thumbnail/260x260>/quality/90!/interlace/1/format/jpg",
                "https://nzr2ybsda.qnssl.com/images/153823/Fi76VUfm2q-M-4Yyls6V8SbGOBIn.jpg?imageMogr2/strip/thumbnail/260x260>/quality/90!/interlace/1/format/jpg"
              ]
            }
        ]
        var index = Math.floor(Math.random()*3)
        var pictureUrl = ''
        if (this.score < 300) {
            pictureUrl = pictures[0].pictures[index]
        } else if (this.score < 600) {
            pictureUrl = pictures[1].pictures[index]
        } else if (this.score < 900) {
            pictureUrl = pictures[2].pictures[index]
        } else if (this.score < 1200) {
            pictureUrl = pictures[3].pictures[index]
        } else if (this.score < 1500) {
            pictureUrl = pictures[4].pictures[index]
        } else if (this.score < 1800) {
            pictureUrl = pictures[5].pictures[index]
        } else {
            pictureUrl = pictures[index].pictures[index]
        }
        
        self.success.addComponent(cc.Sprite)

        cc.loader.load(pictureUrl, function (err, texture) {
            // Use texture to create sprite frame
            var picture = new cc.SpriteFrame(texture);
            console.info(picture)
            self.success.getComponent(cc.Sprite).spriteFrame = picture;
        });
    },
});
