

cc.Class({
    extends: cc.Component,
    /** 游戏的全局变量 */

    properties: {
        /** 游戏节点的注册 */

        // logo节点
        logo: {
            default: null,
            type: cc.Node,
        },

        // btn_start节点
        start_btn: {
            default: null,
            type: cc.Node,
        },

        teacher: {
            default: null,
            type: cc.Node,
        },

        // classroom节点
        classroom: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // index节点
        index: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // hand节点
        hand: {
            default: null,
            type: cc.Node,
        },

        // store number节点
        score_number: {
            default: null,
            type: cc.Label,
        },

        // board节点
        board: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // level节点
        level: {
            default: null,
            type: cc.ProgressBar,
        },

        // failure节点
        failure: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // success节点
        success: {
            default: null,
            type: cc.Node,
            active: false,
        },

        // success_result节点
        success_result: {
            default: null,
            type: cc.Label,
        },

        // 背景音乐节点
        bgMusic: {
            default: null,
            type: cc.AudioSource,
        },

        // slider节点
        slider1: {
            default: null,
            type: cc.Node,
        },
        slider2: {
            default: null,
            type: cc.Node,
        },
        slider3: {
            default: null,
            type: cc.Node,
        }
    },

    initNode: function() {
        var self = this
        self.hand.active = true
        self.index.active = true
        self.success.active = false
    },


    initData: function() {
        // 初始化游戏数据
        this.score = 0; // 分数
        this.timer = 10; // 每一盘游戏的总时间
        this.leftLife = 3; // 剩余的命条数
        this.swivelAnimationTime = 0.5; //转头动画时间 （单向）
        this.flirtAnimationTime = 0.5; //摸的动画时间（单向）
        this.gameState = 'waiting'; // 游戏的状态 waiting(待开始)  action(游戏中)  stop(被抓)  over(分数总结)
    },

    onLoad: function () {
        this.initData()

        // 奖Game组件的实例传入开始按钮
        var startBtn = cc.find('index/start_btn', this.node);
        startBtn.getComponent('Start').game = this;

        // 将Game组件的实例传入teacher
        var teacher = cc.find('teacher', this.node);
        teacher.getComponent('Teacher').game = this;

        // 将Game组件的实例传入hand
        var hand = cc.find('hand', this.node)
        hand.getComponent('Hand').game = this

        // 将Game组件的实例传入playAgain

        var successPlayAgain = cc.find('success/playAgain', this.node)
        successPlayAgain.getComponent('Restart').game = this
        
        var failurePlayAgain = cc.find('failure/playAgain', this.node)
        failurePlayAgain.getComponent('Restart').game = this

        // 播放背景音乐
        this.playBackgroundMusic()

        // 执行轮播图

    },

    // 更改时间进度条
    updateLevelProgress: function() {
        if(this.level.progress > 0) {
            this.level.progress -=  ((1 / this.timer) / 60)
        } else {
            this.gameOver()
        }

        if(this.level.progress < 0.8 && this.level.progress > 0.2) {
            this.level.barSprite.node.color = {
                a: 255,
                b: 234,
                g: 56,
                r: 241
            }
        }  else if (this.level.progress <= 0.2) {
            this.level.barSprite.node.color = {
                a: 255,
                b: 0,
                g: 0,
                r: 255,
            }
        }
    },

    // 添加分数
    gainScore: function() {
        this.score += 1;
        this.score_number.string = this.score.toString();
    },

    // 被抓检测
    getCaught: function() {

        var isFlirting = this.hand.getComponent('Hand').isFlirting
        var isSwiveling = this.teacher.getComponent('Teacher').isSwiveling
        
        return isSwiveling && isFlirting
    },

    // 添加背景音乐

    playBackgroundMusic: function() {
        this.bgMusic.play()
    },

    // 游戏帧循环
    update: function(dt) {
        if (this.gameState === 'action') {
            this.updateLevelProgress()
            if (this.getCaught()) {
                this.gameFail()
            }
        } 
    },

    // 游戏开始
    startGame: function() {
         cc.director.loadScene('game')
    },

    // 游戏暂停
    gameFail: function() {
        this.success_result.string = this.score.toString()
        this.classroom.active = false
        this.failure.active = true
        this.hand.active = false
        this.board.active = false
        this.teacher.active = false
        this.gameState = 'stop'
    },

    // 游戏结束
    gameOver: function() {
        this.success_result.string = this.score.toString()
        this.classroom.active = false
        this.success.active = true
        this.hand.active = false
        this.board.active = false
        this.teacher.active = false
        this.gameState = 'waiting'
    },
});
