cc.Class({
  extends: cc.Component,
  properties: {
    game: {
      default: null,
      type: cc.Node,
    },
    bigHead: {
      default: null,
      type: cc.Node,
    },
    coming: {
      default: null,
      type: cc.Node,
    },
    stupidHead: { // [600, 0]
      default: null,
      type: cc.Node,
    },
    failImage: {  // [750, -30]
      default: null,
      type: cc.Node,
    }
  },

  onLoad: function() {
    this.isYelling = false   // 被抓住显示失败图片的时间
    this.isSwiveling = false // 是否回头
    this.totalTime = 60 * 1000 // 总时间, bed
    this.animationTime = 1 * 1000 // 转头过程单位时间, bed
    this.needSwivelCount = 20 // 需要回头的次数
  },

  swivelAnimation: function() {
    var time = this.animationTime / 10 / 1000

    var enableSwivel = cc.callFunc(function() {
      this.isSwiveling = true
    }, this)

    var disableSwivel = cc.callFunc(function() {
      this.isSwiveling = false
    }, this)

    var bigHead = cc.find("big_head", this.node)
    var stupidHead = cc.find("stupid_head", this.node)

    var action = cc.sequence(
      cc.moveTo(5 * time, cc.p(100, 0)),
      enableSwivel,
      cc.delayTime(4 * time), 
      cc.moveTo(time, cc.p(0, 0)),
      disableSwivel,
    )

    var actionRight = cc.sequence(
      cc.moveTo(5 * time, cc.p(430, 20)),
      enableSwivel,
      cc.delayTime(4 * time), 
      cc.moveTo(time, cc.p(600, 0)),
      disableSwivel,
    )
    if (!this.isYelling) {
      if (Math.random() > 0.5) {
        bigHead.runAction(action)
      } else {
        stupidHead.runAction(actionRight)
      }
    }
  }, 

  // 获取转头时间的数组, [0.6, 1.2, 2.3, 3.4, 4.8, 5.2, 6.3]
  getSwivelTimeArray: function(totalTime, count, animationTime) {
    var timeArray = []
    var interval = totalTime / count
    var ratio = animationTime / interval    // 每个时间段前后间隔，避免边界情况
    for (var i = 0; i < count; i++) {
      // var rand = (Math.random() + i) * interval 
      var rand = (Math.random() * (1 - (ratio / 2)) + i) * interval + (animationTime / 2)
      timeArray.push(rand)
    }
    return timeArray
  },

  startSwivel: function() {
    var swivelTimeArray = this.getSwivelTimeArray(this.totalTime, this.needSwivelCount, this.animationTime)
    var lastTime

    var swivelFunc = (timeArray) => {
      const nextTime = timeArray.shift()
      if (nextTime) {
        var intervel = !!lastTime ? (nextTime - lastTime) : nextTime // 获取下一次的时间间隔
        lastTime = nextTime

        setTimeout(() => {
          this.swivelAnimation()
          if (!this.isYelling) {
            swivelFunc(timeArray)
          }
        }, intervel)
      } 
    }

    swivelFunc(swivelTimeArray)
  },

  showFailImage: function() {
    this.isSwiveling = false
    this.isYelling = true
    var gameFail = cc.callFunc(function() {
      this.game.gameFail()
    }, this)

    var action = cc.sequence(
      cc.moveTo(0.2, cc.p(260, -30)),
      cc.delayTime(40),
      gameFail,
    )

    var bigHead = cc.find("big_head", this.node)
    bigHead.stopAllActions()
    var stupidHead = cc.find("stupid_head", this.node)
    stupidHead.stopAllActions()

    var failImage = cc.find("failImage", this.node)
    failImage.runAction(action)
  },

})