require('./init')
// This component will be the entry point for our entire app based on new architecture design from
// this document: https://striking.quip.com/gazxA3ZruIrs
// It curently only includes very limited functionality, but the goal is to gradually move everything
// to be bootstrap from here

import $ from 'jquery'

import EditorStore from 'js/stores/editor_store'
import EditPage from 'js/v3_bridge/edit_page_bridge'

import * as i18nHelper from 'js/utils/helpers/i18nHelper'

import 'js/vendor/jquery/jquery.ba-hashchange.min'

// HACK: setup event object (v3 legacy, only a fix for old code)
// v3 code still relay on event to communicate with iframes
let Event = null
window.edit_page = EditPage
if (parent.window.edit_page && parent.window.edit_page.Event) {
  Event = parent.window.edit_page.Event
  EditPage.Event = Event
} else {
  Event = EditPage.Event
  if (parent.window.edit_page) {
    parent.window.edit_page.Event = Event
  } else {
    parent.window.edit_page = {
      Event,
    }
  }
}

const p1 = require(`promise-loader?global!locales/${i18nHelper.getTranslationFile()}`)
Promise.all([p1()])
  .then(([poFile]) => {
    const I18n = require('js/utils/i18n')
    I18n.init(poFile)
    $(() => {
      const cloudinary = require('cloudinary')
      const ConfStore = require('js/stores/conf_store')
      cloudinary.config('cloud_name', ConfStore.getCloudinaryCloudName())

      const ctx = EditorStore.init()
      const ReactAppManager = require('js/v4_bridge/react_app_bridge/ReactAppManager')
      ReactAppManager.init(ctx)

      // TODO: use react router
      $(window).hashchange(() => {
        const appName = document.location.hash.replace('#', '')
        if (appName !== '') {
          ReactAppManager.loadApp(appName)
        }
      })
      $(window).hashchange()
    })
  })
  .catch(e => console.error(e))

if (module.hot) {
  module.hot.accept(err => {
    if (err) {
      console.error(err)
    }
  })
}
