import 'js/loadBugsnag'
import './init'
import $ from 'jquery'
import React from 'react'
import ReactDOM from 'react-dom'
import logger from 'js/utils/logger'
import 'js/utils/extensions/native'
import bootstrapSite from 'js/prerender/bootstrapSite'
import * as i18nHelper from 'js/utils/helpers/i18nHelper'
import * as RHL from 'react-hot-loader'

// not widely used, disable it for now
// require('./registerPWA.es6')

// These two are direct reads so promises can be fired quicker
const themeName = $S.stores.pageMeta.theme.name
const forcedLocale = $S.stores.pageMeta.forced_locale

// Load dynamic theme style files on editor debug environment
if (__MODE__ === "'editor-debug'") {
  require('reset')
  require(`themes/${themeName}/main_v4`)
}

const p1 = import(`locales/${i18nHelper.getTranslationFile(
  forcedLocale,
)}`)
const p2 = import(`manifests/themes/${themeName}.js`)
const p3 = import(`manifests/verticals/${themeName}.js`)

Promise.all([p1, p2, p3])
  .then((...args) => {
    const [poFile, manifest, verticalData] = Array.from(args[0])
    if (!window.timerStart) {
      window.timerStart = new Date().getTime()
    }
    window.timerCheck = function(label) {
      const msg = `${label} in ${new Date().getTime() - timerStart}ms`
      console.log(msg)
    }

    const BootstrappedSite = bootstrapSite({
      poFile,
      manifest,
      verticalData,
    })

    $(() => {
      require('./v3_bridge')()
      ReactDOM.render(
        <BootstrappedSite />,
        document.getElementById('s-page-container'),
      )

      const ConfStore = require('js/stores/conf_store')
      if (ConfStore.isStrikinglyLiveChatEnabled()) {
        const SupportWidget = require('js/components/support_widget/SupportWidget')
        ReactDOM.render(
            <RHL.AppContainer>
              <SupportWidget />
            </RHL.AppContainer>,
          document.getElementById('s-support-widget-container'),
        )
      }
    })
  })
  .catch(e => console.error(e))
// catch errors and call console.error so that they are reported by Bugsnag
