const _ = require('lodash')

const TEMPLATES = ['.babelrc', 'webpack.common.js', 'webpack.config.js']

const PACKAGES = [
  { name: 'awesome-typescript-loader', version: '^5.2.0' },
  { name: 'babel-loader', version: '^7.1.5' },
  { name: 'babel-runtime', version: '^6.26.0' },
  { name: 'babel-core', version: '^6.26.3' },
  { name: 'babel-preset-env', version: '^1.7.0' },
  { name: 'bundle-loader', version: '^0.5.6' },
  { name: 'cache-loader', version: '^1.2.2' },
  { name: 'css-loader', version: '^1.0.0' },
  { name: 'extract-text-webpack-plugin', version: '^4.0.0-beta.0' },
  { name: 'file-loader', version: '^1.1.11' },
  { name: 'happypack', version: '^5.0.0' },
  { name: 'img-loader', version: '^3.0.0' },
  { name: 'postcss-loader', version: '^2.1.6' },
  { name: 'progress-bar-webpack-plugin', version: '^1.11.0' },
  { name: 'sw-precache-webpack-plugin', version: '^0.11.5' },
  { name: 'ts-loader', version: '^4.4.2' },
  { name: 'url-loader', version: '^1.0.1' },
  { name: 'webpack', version: '^4.16.0' },
  { name: 'webpack-dev-server', version: '^3.1.4' },
  { name: 'webpack-parallel-uglify-plugin', version: '^1.1.0' },
  { name: 'friendly-errors-webpack-plugin', version: '^1.7.0' },
  { name: 'webpack-manifest-plugin', version: '^2.0.3' }
]

/**
 * some legacy codes us promise-loader and json-loader to dynamic import json file
 * now it can be achieved by simply using import()
 * fonts.json uses C style muliline comment, which violates JSON spec
 * gerateFontsJSON.js is the criminal who generates illegal JSON
 */
const multiLineCommentRegex = /\/\*[\s\S]*?\*\/$/gm
const multiLineCommentStringRegex = /`\/\*[\s\S]*?\*\/\n`$/gm
// use regex instead of plain string for replacing all occurances
const requirePromisLoaderRegex = new RegExp(
  _.escapeRegExp('require(`promise-loader?global!'),
  'g'
)

const LEGACY_CODES = [
  {
    name: 'config/fonts.json',
    update: content => content.replace(multiLineCommentRegex, '')
  },
  {
    name: 'fe/js/BlogEditor.es6',
    update: content =>
      content
        .replace(requirePromisLoaderRegex, 'import(`')
        .replace('Promise.all([p1(), p2()])', 'Promise.all([p1, p2])')
  },
  {
    name: 'fe/js/blog.client.es6',
    update: content =>
      content
        .replace(requirePromisLoaderRegex, 'import(`')
        .replace('Promise.all([p1(), p2()])', 'Promise.all([p1, p2])')
  },
  {
    name: 'fe/js/stores/font_store.es6',
    update: content =>
      content
        .replace(
          `import loadFonts from 'promise-loader?global!json5-loader!../../../config/fonts.json'`,
          ''
        )
        .replace(
          'return loadFonts()',
          `return import('../../../config/fonts.json')`
        )
  },
  {
    name: 'fe/js/utils/helpers/EcommerceHelper.es6',
    update: content =>
      content.replace('require(`promise-loader?global!json-loader!', 'import(`')
  },
  {
    name: 'fe/js/v3_bridge/page_analytics_engine.es6',
    update: content => content.replace('json-loader!', '')
  },
  {
    name: 'fe/lib/webpack/entries-generation-webpack-plugin.js',
    update: content =>
      content.replace(
        `isInitial: chunk.isInitial ? chunk.isInitial() : chunk.initial`,
        `isInitial: chunk.isInitial ? chunk.isInitial() : chunk.isOnlyInitial()`
      )
  },
  {
    name: 'fe/nextgen/app.es6',
    update: content =>
      content
        .replace('require(`promise-loader?global!', 'import(`')
        .replace('Promise.all([p1()])', 'Promise.all([p1])')
  },
  {
    name: 'fe/scripts/fonts/generateFontsJson.js',
    update: content => content.replace(multiLineCommentStringRegex, `''`)
  }
]

const BACKUP_FILES = [
  '.babelrc',
  'package.json',
  'webpack.common.js',
  'webpack.config.js',
  'yarn.lock',
  'config/fonts.json',
  'fe/js/BlogEditor.es6',
  'fe/js/blog.client.es6',
  'fe/js/stores/font_store.es6',
  'fe/js/utils/helpers/EcommerceHelper.es6',
  'fe/js/v3_bridge/page_analytics_engine.es6',
  'fe/lib/webpack/entries-generation-webpack-plugin.js',
  'fe/nextgen/app.es6',
  'fe/scripts/fonts/generateFontsJson.js'
]

module.exports = {
  TEMPLATES,
  PACKAGES,
  LEGACY_CODES,
  BACKUP_FILES,
}
