#!/usr/bin/env node
const inquirer = require('inquirer')
const { spawn } = require('child_process')

const {
  updateConfigFiles,
  updateLegacyCodes,
  upgradePackages,
  preserveOldFiles
} = require('../packages/actions')

const BANNER = `
             *                      *
                     .
          |\\___/|
          )     (             .              *
         =\\     /=
           )===(       *
          /     \\
          |     |
         /       \\
         \\       /
  _/\\_/\\_/\\__  _/_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_/\\_
  |  |  |  |( (  |  |  |  |  |  |  |  |  |  |
  |  |  |  | ) ) |  |  |  |  |  |  |  |  |  |
  |  |  |  |(_(  |  |  |  |  |  |  |  |  |  |
  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |
`

const main = async () => {
  console.info(BANNER)

  const { mode } = await inquirer.prompt([
    {
      name: 'mode',
      type: 'list',
      message: [
        'Which mode would like to choose:',
        '  🚝  chill - webpack 4, ES2018 output, cheap-eval-source-map',
        '  🚀  mad max - coming soon ...',
        // '  🚀  mad max - webpack 4, ES2018 output, no source map, no backend log',
        ''
      ].join('\n'),
      // choices: ['chill', 'mad max']
      choices: ['chill']
    }
  ])

  console.log('Preserve current configs ...')
  preserveOldFiles()
  console.log('Update config files ...')
  updateConfigFiles(mode)
  console.log('Update legacy codes ...')
  updateLegacyCodes()
  console.log('Upgrade pacakages ...')
  upgradePackages()

  console.log('yarn dev')
  // since shelljs.exec doesn't work with inqurier.js
  // use spawn instead
  spawn('yarn', ['dev'], {
    stdio: 'inherit'
  })
}

main()
