require('./init')

import React from 'react'
import $ from 'jquery'
import ReactDOM from 'react-dom'
import { AppContainer } from 'react-hot-loader'
import { ErrorBoundary } from 'js/components/ErrorBoundary'
import * as i18nHelper from 'js/utils/helpers/i18nHelper'

import PhotoPage from './components/PhotoPage'

require('./utils/extensions/native')

const p1 = require(`promise-loader?global!locales/${i18nHelper.getTranslationFile(
  'zh_CN',
)}`)

Promise.all([p1()]).then(([poFile]) => {
  const I18n = require('js/utils/i18n')
  I18n.init(poFile)

  $(() => {
    ReactDOM.render(
      <ErrorBoundary>
        <AppContainer>
          <PhotoPage setType="background" />
        </AppContainer>
      </ErrorBoundary>,
      document.getElementById('photo-page'),
    )
  })
})

if (module.hot) {
  module.hot.accept(err => {
    if (err) {
      console.error(err)
    }
  })
}
