import 'js/loadBugsnag'
import './init'

import React from 'react'
import ReactDOM from 'react-dom'
import $ from 'jquery'
import logger from 'js/utils/logger'

import * as i18nHelper from 'js/utils/helpers/i18nHelper'

import bootstrapBlog from 'js/prerender/bootstrapBlog'
import ComponentKitContext from 'js/utils/ComponentKitContext'

if (typeof window.timerStart === 'undefined') {
  window.timerStart = new Date().getTime()
}

window.timerCheck = function(label) {
  const time = new Date().getTime() - window.timerStart
  const msg = `${label} in ${time}ms`
  logger.log(msg)
  return msg
}

window.edit_page = require('js/v3_bridge/edit_page_bridge')

window.edit_page.isBlog = true
window.edit_page.isShowPage = true

// These two are direct reads so promises can be fired quicker
// const locale = $S.globalConf.locale
const themeName = $S.blogPostData.pageMeta.theme.name_with_v4_fallback
const forcedLocale = $S.blogPostData.pageMeta.forcedLocale

const p1 = require(`promise-loader?global!locales/${i18nHelper.getTranslationFile(
  forcedLocale,
)}`)
const p2 = require(`promise-loader?global!manifests/themes/${themeName}.js`)
Promise.all([p1(), p2()])
  .then(([poFile, manifest]) => {
    const BlogBootstrap = ComponentKitContext(
      bootstrapBlog({
        poFile,
        manifest,
      }),
    )

    $(() => {
      ReactDOM.render(
        <BlogBootstrap />,
        document.getElementById('s-blog-container'),
      )
      window.timerCheck('React has finished rendering')
    })
  })
  .catch(e => console.error(e))
