import * as api from './service'

export default {
  namespace: 'products',
  state: {
    categories: [],
    categoryId: null,
    products: [],
  },
  effects: {
    * categories(_, {
      call,
      put,
      select,
    }) {
      const { siteId } = yield select(state => state.global)
      const { data } = yield call(api.categories, {
        siteId,
      })
      yield put({
        type: 'save',
        payload: {
          categories: data
        },
      })
      yield put({
        type: 'save',
        payload: {
          categoryId: data && data.length && data[0].id,
        },
      })
      yield put({
        type: 'products',
      })
    },
    * products(_, {
      call,
      put,
      select,
    }) {
      const { categoryId } = yield select(state => state.products)
      const { currentStoreFrontId } = yield select(state => state.home)
      const { data } = yield call(api.products, {
        storefrontsId: currentStoreFrontId,
        categoryId,
        from: 0,
        per: 999,
      })
      yield put({
        type: 'save',
        payload: {
          products: data.products
        }
      })
    }
  },
  reducers: {
    save (state, {
      payload,
    }) {
      return {
        ...state,
        ...payload,
      }
    },
  }
}
