import Taro from '@tarojs/taro'

import Request from '../../utils/request'
import extJson from '../../../ext.json'

const isWeApp = process.env.TARO_ENV === 'weapp'

export const settings = data => Request({
  url: `/r/v1/sites/${data.siteId}/restaurant/settings`,
  method: 'GET',
})

export const getExtConfig = () => {
  return new Promise((resolve, reject) => {
    if (isWeApp) {
      Taro.getExtConfig({
        success: (res) => {
          resolve(res.extConfig)
        },
        fail: (error) => {
          reject(error)
        },
      })
    } else {
      resolve(extJson.ext)
    }
  })
}
