import * as homeApi from './service';

export default {
  namespace: 'home',
  state: {
    settings: {},
    currentStoreFrontId: null,
  },
  effects: {
    * load(_, {
      call,
      put,
      select,
    }) {
      const { attr, style } = yield call(homeApi.getExtConfig)
      yield put({
        type: 'global/save',
        payload: attr,
      })
      const { siteId } = yield select(state => state.global)
      const { data } = yield call(homeApi.settings, {
        siteId,
      })
      yield put({
        type: 'saveSettings',
        payload: {
          settings: data,
        }
      })
      yield put({
        type: 'products/categories',
      })
      yield put({
        type: 'saveSettings',
        payload: {
          currentStoreFrontId: data.storefronts && data.storefronts[0].id
        }
      })
    },
  },
  reducers: {
    saveSettings(state, {
      payload
    }) {
      return { ...state,
        ...payload
      };
    },
  },
};
