import * as homeApi from './service';

export default {
  namespace: 'home',
  state: {
    settings: {},
  },
  effects: {
    * load(_, {
      call,
      put
    }) {
      const { data } = yield call(homeApi.settings, {
        siteId: '11536422',
      })
      yield put({
        type: 'saveSettings',
        payload: {
          settings: data,
        }
      })
    },
  },
  reducers: {
    saveSettings(state, {
      payload
    }) {
      return { ...state,
        ...payload
      };
    },
  },
};
