import Taro, { Component } from '@tarojs/taro';
import { View } from '@tarojs/components';
import { connect } from '@tarojs/redux';
import { AtAvatar } from 'taro-ui'
import ProductTabs from '../productTabs/productTabs'
import './index.scss';

@connect(({home}) => ({
  ...home,
}))
export default class Index extends Component {
  config = {
    navigationBarTitleText: '菜单',
  }

  componentDidMount = () => {
    this.props.dispatch({
      type: 'home/load',
    })
  }

  render() {
    const { settings } = this.props
    const storeFronts = settings.storefronts && settings.storefronts[0] || {}
    return (
      <View className="home-page">
        <View className="store">
          <View className="store-inner">
            <View className="logo-wrap">
              <AtAvatar className="logo" circle image="https://user-assets.sxlcdn.com/images/450112/Fp6dr7TBVawyKJqTTG40X_bVZ_Nd.jpg?imageMogr2/strip/auto-orient/thumbnail/2000x3000%3E/quality/90!/interlace/1/format/jpg" />
            </View>
            <View className="info">
              <View className="name">{storeFronts.name}</View>
              <View className="take-out-settings">外卖服务起送价10元 · 配送费2元 </View>
            </View>
          </View>
        </View>
        <ProductTabs />
      </View>
    )
  }
}

