import Taro, { Component } from '@tarojs/taro';
import { View } from '@tarojs/components';
import { AtTabs, AtTabsPane } from 'taro-ui'
import { connect } from '@tarojs/redux'

import Loading from '../../components/Loading/Loading'

@connect(({ products, loading }) => ({
  ...products,
  ...loading,
}))
export default class ProductTabs extends Component {
  handleClick (value) {
    const { categories } = this.props
    this.props.dispatch({
      type: 'products/save',
      payload: {
        categoryId: categories[value].id,
      }
    })
    this.props.dispatch({
      type: 'products/products'
    })
    this.setState({
      current: value,
    })
  }
  componentDidMount() {
    const { dispatch } = this.props
    dispatch({
      type: 'products/categories'
    })
  }

  getTitle() {
    const { categories } = this.props
    const names = categories.map(category => {
      return {
        title: category.name,
      }
    })
    return names
  }

  render () {
    const { categories, categoryId, global } = this.props
    const { current } = this.state
    const tabList = this.getTitle()
    return (
      <AtTabs
        current={current}
        scroll
        height='400px'
        tabDirection='vertical'
        tabList={tabList}
        onClick={this.handleClick.bind(this)}>
          {
            global ?
            (<Loading />) :
            categories.map(category => {
              return (
                <AtTabsPane tabDirection='vertical' current={current} index={category.id} key={category.id}>
                  <View style='font-size:18px;text-align:center;height:200px;'>标签页${category.id}的内容</View>
                </AtTabsPane>
              )
            })
          }
        </AtTabs>
    )
  }
}
