import '@tarojs/async-await'
import Taro, { Component } from '@tarojs/taro'
import Home from './pages/home'
import dva from './utils/dva'
import models from './models'
import { Provider } from '@tarojs/redux'

import './styles/base.scss'


const dvaApp = dva.createApp({
  initialState: {},
  models: models,
});
const store = dvaApp.getStore();

class App extends Component {

  config = {
    pages: [
      'pages/home/index',
      'pages/cart/index',
      'pages/user/index',
    ],
    window: {
      backgroundTextStyle: 'dark',
      navigationBarBackgroundColor: '#346b30',
      navigationBarTitleText: '点餐小程序',
      navigationBarTextStyle: 'white'
    },
    tabBar: {
      list: [{
        pagePath: "pages/home/index",
        text: "首页",
        iconPath: "./images/tab/icon-home.png",
        selectedIconPath: "./images/tab/icon-home-selected.png"
      }, {
        pagePath: "pages/cart/index",
        text: "订单",
        iconPath: "./images/tab/icon-order.png",
        selectedIconPath: "./images/tab/icon-order-selected.png"
      },{
        pagePath: "pages/user/index",
        text: "更多",
        iconPath: "./images/tab/icon-mine.png",
        selectedIconPath: "./images/tab/icon-mine-selected.png"
      }],
      color: '#fff',
      selectedColor: '#fff',
      backgroundColor: '#346b30',
      borderStyle: '#ccc'
    }
  }

  componentDidMount() {

  }

  render() {
    return (<Provider store={store}>
      <Home/>
    </Provider>);
  }
}

Taro.render(<App/>, document.getElementById('app'))
